/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.DerivedUnit;
import javax.measure.unit.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompoundUnit<Q extends Quantity>
extends DerivedUnit<Q> {
    private final Unit<Q> _low;
    private final Unit<Q> _high;
    private static final long serialVersionUID = 1L;

    CompoundUnit(Unit<Q> high, Unit<Q> low) {
        if (!high.toSI().equals(low.toSI())) {
            throw new IllegalArgumentException("Cannot compound " + high + " with " + low);
        }
        if (low instanceof CompoundUnit) {
            this._high = high.compound(((CompoundUnit)low).getHigh());
            this._low = ((CompoundUnit)low).getLow();
        } else {
            this._high = high;
            this._low = low;
        }
    }

    public Unit<Q> getLow() {
        return this._low;
    }

    public Unit<Q> getHigh() {
        return this._high;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof CompoundUnit)) {
            return false;
        }
        CompoundUnit thatUnit = (CompoundUnit)that;
        return this._low.equals(thatUnit._low) && this._high.equals(thatUnit._high);
    }

    @Override
    public int hashCode() {
        return this._high.hashCode() ^ this._low.hashCode();
    }

    @Override
    public String toString() {
        return this._high + ":" + this._low;
    }

    @Override
    public Unit<Q> toSI() {
        return this._low.toSI();
    }

    @Override
    public final UnitConverter getConverterTo(Unit<Q> unit) {
        return this._low.getConverterTo(unit);
    }
}

