/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.GroovyCallInterceptorsProvider;
import org.gradle.internal.classpath.intercept.CallSiteDecorator;
import org.gradle.internal.classpath.intercept.CallSiteInterceptorSet;
import org.gradle.internal.classpath.intercept.DefaultCallSiteDecorator;
import org.gradle.internal.classpath.intercept.DefaultCallSiteInterceptorSet;
import org.gradle.internal.classpath.intercept.DefaultJvmBytecodeInterceptorFactorySet;
import org.gradle.internal.classpath.intercept.JvmBytecodeInterceptorFactoryProvider;
import org.gradle.internal.classpath.intercept.JvmBytecodeInterceptorFactorySet;
import org.gradle.internal.classpath.intercept.JvmBytecodeInterceptorSet;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;

@NonNullApi
public class CallInterceptorRegistry {
    private static final Map<ClassLoader, Boolean> LOADED_FROM_CLASSLOADERS = Collections.synchronizedMap(new WeakHashMap());
    private static volatile Map<BytecodeInterceptorFilter, CallSiteDecorator> groovyDecorators = new ConcurrentHashMap<BytecodeInterceptorFilter, CallSiteDecorator>();
    private static volatile Map<BytecodeInterceptorFilter, JvmBytecodeInterceptorSet> jvmInterceptorSets = new ConcurrentHashMap<BytecodeInterceptorFilter, JvmBytecodeInterceptorSet>();
    private static volatile CallSiteInterceptorSet currentGroovyCallInterceptorSet = new DefaultCallSiteInterceptorSet(GroovyCallInterceptorsProvider.DEFAULT);
    private static volatile JvmBytecodeInterceptorFactorySet currentJvmBytecodeFactorySet = new DefaultJvmBytecodeInterceptorFactorySet(JvmBytecodeInterceptorFactoryProvider.DEFAULT);

    public static synchronized void loadCallInterceptors(ClassLoader classLoader) {
        if (LOADED_FROM_CLASSLOADERS.put(classLoader, true) != null) {
            throw new RuntimeException("Cannot load interceptors twice for class loader: " + classLoader);
        }
        GroovyCallInterceptorsProvider.ClassLoaderSourceGroovyCallInterceptorsProvider classLoaderGroovyCallInterceptors = new GroovyCallInterceptorsProvider.ClassLoaderSourceGroovyCallInterceptorsProvider(classLoader);
        GroovyCallInterceptorsProvider callInterceptors = GroovyCallInterceptorsProvider.DEFAULT.plus(classLoaderGroovyCallInterceptors);
        CallInterceptorRegistry.setCurrentGroovyCallInterceptorSet(new DefaultCallSiteInterceptorSet(callInterceptors));
        JvmBytecodeInterceptorFactoryProvider.ClassLoaderSourceJvmBytecodeInterceptorFactoryProvider classLoaderJvmBytecodeInterceptors = new JvmBytecodeInterceptorFactoryProvider.ClassLoaderSourceJvmBytecodeInterceptorFactoryProvider(classLoader);
        CallInterceptorRegistry.setCurrentJvmBytecodeFactorySet(new DefaultJvmBytecodeInterceptorFactorySet(JvmBytecodeInterceptorFactoryProvider.DEFAULT.plus(classLoaderJvmBytecodeInterceptors)));
    }

    public static CallSiteDecorator getGroovyCallDecorator(BytecodeInterceptorFilter interceptorFilter) {
        return groovyDecorators.computeIfAbsent(interceptorFilter, key -> new DefaultCallSiteDecorator(currentGroovyCallInterceptorSet.getCallInterceptors(interceptorFilter)));
    }

    private static void setCurrentGroovyCallInterceptorSet(CallSiteInterceptorSet interceptorSet) {
        groovyDecorators = new ConcurrentHashMap<BytecodeInterceptorFilter, CallSiteDecorator>();
        currentGroovyCallInterceptorSet = interceptorSet;
    }

    public static JvmBytecodeInterceptorSet getJvmBytecodeInterceptors(BytecodeInterceptorFilter interceptorFilter) {
        return jvmInterceptorSets.computeIfAbsent(interceptorFilter, key -> currentJvmBytecodeFactorySet.getJvmBytecodeInterceptorSet(interceptorFilter));
    }

    private static void setCurrentJvmBytecodeFactorySet(JvmBytecodeInterceptorFactorySet interceptorSet) {
        jvmInterceptorSets = new ConcurrentHashMap<BytecodeInterceptorFilter, JvmBytecodeInterceptorSet>();
        currentJvmBytecodeFactorySet = interceptorSet;
    }

    @NonNullApi
    @VisibleForTesting
    static class GroovyJvmCallInterceptorInternalTesting {
        GroovyJvmCallInterceptorInternalTesting() {
        }

        static CallSiteInterceptorSet getCurrentGroovyCallInterceptorSet() {
            return currentGroovyCallInterceptorSet;
        }

        static void setCurrentGroovyCallInterceptorSet(CallSiteInterceptorSet interceptorsSet) {
            CallInterceptorRegistry.setCurrentGroovyCallInterceptorSet(interceptorsSet);
        }

        static JvmBytecodeInterceptorFactorySet getCurrentJvmBytecodeInterceptorFactorySet() {
            return currentJvmBytecodeFactorySet;
        }

        static void setCurrentJvmBytecodeInterceptorFactorySet(JvmBytecodeInterceptorFactorySet interceptorFactorySet) {
            CallInterceptorRegistry.setCurrentJvmBytecodeFactorySet(interceptorFactorySet);
        }
    }
}

